/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.analyse;

import java.io.FileWriter;
import java.io.IOException;

public class Article {
    private int id;
    private String titre;
    private String description;
    private String[] lemmesTitre;
    private String[] lemmesDescription;
    private String url;
    private String source;
    private String datePubli;
    private int statut;

    public final static int VALIDE = 0;
    public final static int SUGGERE = 1;
    public final static int INITIAL = 2;


    public Article(int id, String titre, String description, 
            String[] lemmesTitre, String[] lemmesDescription,
            String url, String source, String datePubli, int statut) {
        this.id = id;
        this.titre = titre;
        this.description = description;
        this.lemmesTitre = lemmesTitre;
        this.lemmesDescription = lemmesDescription;
        this.url = url;
        this.source = source;
        this.datePubli = datePubli;
        this.statut = statut;
        if(statut != VALIDE && statut!= INITIAL){
            statut = SUGGERE;
        }
    }

    public int getStatut() {
        return statut;
    }

    public void setStatut(int statut) {
        this.statut = statut;
        if(statut != VALIDE && statut!= INITIAL){
            statut = SUGGERE;
        }
    }

    public int getId() {
        return id;
    }

    public String getDescription() {
        return description;
    }

    public String[] getLemmesDescription() {
        return lemmesDescription;
    }

    public String[] getLemmesTitre() {
        return lemmesTitre;
    }

    public String getSource() {
        return source;
    }

    public String getTitre() {
        return titre;
    }

    public String getDatePubli() {
        return datePubli;
    }

    public String getUrl() {
        return url;
    }

    @Override
    public boolean equals(Object obj) {
        return id==((Article)obj).id;
    }

    @Override
    public int hashCode() {
        return id+titre.hashCode()+description.hashCode()+url.hashCode();
    }

    @Override
    public Article clone(){
        return new Article(id, titre, description,
            lemmesTitre, lemmesDescription,
            url, source, datePubli, statut);
    }

    String getSauvegarde(){
        String s = "<Id>"+id+"</Id>";
        s += "<Titre>"+titre+"</Titre>";
        s += "<Description>"+description+"</Description>";
        s += "<LemmesTitre>";
        for(int i=0; i<lemmesTitre.length; i++){
            s += lemmesTitre[i];
            if(i < lemmesTitre.length-1){
                s += "|";
            }
        }
        s += "</LemmesTitre>";
        s += "<LemmesDescription>";
        for(int i=0; i<lemmesDescription.length; i++){
            s += lemmesDescription[i];
            if(i < lemmesDescription.length-1){
                s += "|";
            }
        }
        s += "</LemmesDescription>";
        s += "<Url>"+url+"</Url>";
        s += "<Source>"+source+"</Source>";
        s += "<DatePubli>"+datePubli+"</DatePubli>";
        s += "<Statut>"+statut+"</Statut>";
        return s;
    }
    
    void sauvegarde(FileWriter out) throws IOException {
        out.write("<Id>"+id+"</Id>");
        out.write("<Titre>"+titre+"</Titre>");
        out.write("<Description>"+description+"</Description>");
        out.write("<LemmesTitre>");
        for(int i=0; i<lemmesTitre.length; i++){
            out.write(lemmesTitre[i]);
            if(i < lemmesTitre.length-1){
                out.write("|");
            }
        }
        out.write("</LemmesTitre>");
        out.write("<LemmesDescription>");
        for(int i=0; i<lemmesDescription.length; i++){
            out.write(lemmesDescription[i]);
            if(i < lemmesDescription.length-1){
                out.write("|");
            }
        }
        out.write("</LemmesDescription>");
        out.write("<Url>"+url+"</Url>");
        out.write("<Source>"+source+"</Source>");
        out.write("<DatePubli>"+datePubli+"</DatePubli>");
        out.write("<Statut>"+statut+"</Statut>");
    }

    static Article charge(String sauvegarde){
        int id = Integer.parseInt(sauvegarde.split("<Id>")[1].split("</Id>")[0].trim());
        String titre = sauvegarde.split("<Titre>")[1].split("</Titre>")[0].trim();
        String description = sauvegarde.split("<Description>")[1].split("</Description>")[0].trim();
        String url = sauvegarde.split("<Url>")[1].split("</Url>")[0].trim();
        String source = sauvegarde.split("<Source>")[1].split("</Source>")[0].trim();
        String datePubli = sauvegarde.split("<DatePubli>")[1].split("</DatePubli>")[0].trim();
        int statut = Integer.parseInt(sauvegarde.split("<Statut>")[1].split("</Statut>")[0].trim());
        //String[] lemmesTitre = sauvegarde.split("<LemmesTitre>")[1].split("</LemmesTitre>")[0].trim().split("|");
        //String[] lemmesDescription = sauvegarde.split("<LemmesDescription>")[1].split("</LemmesDescription>")[0].trim().split("|");
        Article res = new Article(id, titre, description,
            /*lemmesTitre, lemmesDescription,*/new String[]{}, new String[]{},
            url, source, datePubli, statut);
        return res;
    }

    public String toString(){
        return "<html><b>["+source+"]</b> - "+datePubli+"<br>"+titre+"<br><i><font size=\"-1\">"+description+"</font><i></html>";
    }
}
